 # delimit ;  
set more 1 ;
capture log close;
* this program generates moments for the bivariate distribution hospital nights and medical costs ;

cd C:\Dropbox\hrs\wealthcouples;

log using medex_AR\momentdm.log, replace ;
drop _all;
program drop _all;

* GENERATE OF COUPLE OF PROCEDURES BELOW;
*NOW GENERATE THE ELEMENTS OF THE COVARIANCE MATRIX (IE, MOMENT CONDITION CONTRIBUTIONS);
program define moments;
        version 3.1;
local i = 1 ; 
local k=1;
while `i' <=numyear { ;

replace icounter=`i';
replace jmax=numyear-icounter;
	local j=icounter;
		while `j'<=numyear {;
			gen momvec`k'=med`i'*med`j';
		local k=`k'+1;
	local j = `j' +1};
local i = `i'+1 } ;
end;

* generate matrix of demeaned variables used to generate variance-covariance matrix for the data;
program define mydata;
        version 3.1;
    local i = 1 ;
    while `i' <=nummom { ;
    	gen vec`i'=0;
    	replace vec`i'=momvec`i' if momvec`i'~=.;
	gen uthere`i'=0;
	replace uthere`i'=1 if (momvec`i'~=. & momvec`i'~=0);
local i = `i'+1 } ;
end;

* this program compresses all data about an individual onto one observation;

program define merged;
        version 3.1;
	sort indnum wave;
    local i = 1 ;
    while `i' <=$totwave { ;		
	replace med`i'=med`i'[_n-1] if med`i'==0 & indnum==indnum[_n-1];	
	replace medl`i'=medl`i'[_n-1] if medl`i'==. & indnum==indnum[_n-1];	
local i = `i'+1 } ;
sort indnum wave;
end;

program define merger;
  version 3.1;
  sort indnum wave;
    local i = 1 ;
    while `i' <=$totwave { ;
	gen med`i'=0;
	gen medl`i'=.;	
	
	replace med`i'=med if wave==`i' & med~=.;
	replace medl`i'=med if wave==`i';

local i = `i'+1 } ;
sort indnum wave;
end;


***************************************************;
* here I generate matrices that are fed into GAUSS ;

use normalizedresid;

sort wave;

by wave: sum normalizedresid;

*because we use lagge dhealth status we have missing residuals in wave 3;
drop if wave==3;
sum wave;
replace wave=wave-r(min)+1;

tab wave;

sum wave;

global totwave=r(max);

* we will fix this later;
drop if wave>$totwave; 

drop if normalizedresid==.;

rename normalizedresid med;
rename HHID indnum;

* procedure below;
merger;

sum med* ;

* procedure below;
merged;
sum med* ;

drop if indnum==indnum[_n+1]; 

sum med* ;

*forvalues x = 1/$totwave {;
*drop if medl`x'==.;
*};
sum med*;


* have a look at the covariance matrix here;
* INTERESTING FINDING! -- NOTE THAT THIS COVARIANCE MATRIX IS FOR THE "BALANCED" PANEL - THE VARIANCES AND COVARIANCES ARE MUCH LARGER IN THE UNBALANCED PANEL;
corr medl*, covariance;

corr medl* ;

gen icounter=0;
gen jmax=0;

save Medex_AR\moments, replace;
replace medl1=.;
sort indnum;
keep medl*;
forvalues x = 1/$totwave { ;
gen uthere`x'=0;
replace uthere`x'=1 if medl`x'~=.; 
};
aorder; 
sum;
outsheet using Medex_AR\mydat, nonames replace;
drop _all;

****************************************************;
* what is below is just for medical costs **********;
****************************************************;
use Medex_AR\moments;
gen numyear=$totwave;
gen nummom=($totwave*($totwave+1))/2;
* couple of procedures below;
moments;
sum mom*;
mydata;
sum vec* momv* uthere*;
* KEEP THE VARIABLES I NEED;
keep vec* uthere* indnum;
sort indnum;
drop indnum;
aorder; 
*orders vec1-vec15 uthere1-uthere15;
summ;
outsheet using Medex_AR\momentm, nonames replace;
save Medex_AR\momentm, replace;
summ;
drop _all;


drop _all;
log close;

